package test;

import org.pgusb.usb4allLib.Usb4allBoard;
import org.pgusb.usb4allLib.Usb4allDevice;

import examples.LoopBack;
import exceptions.Usb4allException;

public class TestLoopBack1 {
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		Usb4allBoard board = new Usb4allBoard();
		LoopBack loopBack = new LoopBack(Usb4allDevice.BULK_IN,Usb4allDevice.BULK_OUT); 
		try {
			board.init();
			for (int j=0 ; j<100; j++){
				
			//Thread.sleep(1);
			loopBack.setBoard(board);
			loopBack.init();
			//creo lo que voy a mandar
			int largoMax=8;
			byte[] sendBytes = new byte[largoMax];
			for (int largo = 0 ; largo<largoMax ; largo ++){
				sendBytes[largo]=(byte)(largo*2);
			}
			for(int i=0;i<200;i++){
			
				System.out.print("send : ");
				printByteArray(sendBytes);
				System.out.print("  --  recibo: ");
				printByteArray(loopBack.sendReceive(sendBytes));
				System.out.println();
				//Thread.sleep(1000);
			}
			loopBack.release();
			}
			System.out.println("termine");
	
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}/* catch (InterruptedException ex) {
			// TODO Auto-generated catch block
			ex.printStackTrace();
		}*/
	}
	
	public static void printByteArray(byte[] c){
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		//System.out.println();
	}
	
}
